'use strict';

exports.readRelationships = readRelationships;
exports.defaultValue = new Relationships([]);
exports.Relationships = Relationships;


function readRelationships(element) {
  const relationships = [];
  element.children.forEach(function(child) {
    if (child.name === '{http://schemas.openxmlformats.org/package/2006/relationships}Relationship') {
      const relationship = {
        relationshipId: child.attributes.Id,
        target: child.attributes.Target,
        type: child.attributes.Type,
      };
      relationships.push(relationship);
    }
  });
  return new Relationships(relationships);
}

function Relationships(relationships) {
  const targetsByRelationshipId = {};
  relationships.forEach(function(relationship) {
    targetsByRelationshipId[relationship.relationshipId] = relationship.target;
  });

  const targetsByType = {};
  relationships.forEach(function(relationship) {
    if (!targetsByType[relationship.type]) {
      targetsByType[relationship.type] = [];
    }
    targetsByType[relationship.type].push(relationship.target);
  });

  return {
    findTargetByRelationshipId(relationshipId) {
      return targetsByRelationshipId[relationshipId];
    },
    findTargetsByType(type) {
      return targetsByType[type] || [];
    },
  };
}
